<?php
class sevenTranslate {

    public static function translate($source, $target, $text) {

        $response 		= self::requestTranslation($source, $target, $text);
        $translation 	= self::getSentencesFromJSON($response);
        return $translation;

    }

    protected static function requestTranslation($source, $target, $text) {

        $url = "https://translate.google.com/translate_a/single?client=at&dt=t&dt=ld&dt=qca&dt=rm&dt=bd&dj=1&hl=es-ES&ie=UTF-8&oe=UTF-8&inputm=2&otf=2&iid=1dd3b944-fa62-4b55-b330-74909a99969e";

        $fields = array(
            'sl' => urlencode($source),
            'tl' => urlencode($target),
            'q' => urlencode($text)
        );

        $fields_string = "";
        foreach($fields as $key=>$value) {
            $fields_string .= $key.'='.$value.'&';
        }

        rtrim($fields_string, '&');
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, count($fields));
        curl_setopt($ch, CURLOPT_POSTFIELDS, $fields_string);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_ENCODING, 'UTF-8');
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_USERAGENT, 'AndroidTranslate/5.3.0.RC02.130475354-53000263 5.1 phone TRANSLATE_OPM5_TEST_1');

        $result = curl_exec($ch);

        curl_close($ch);
        return $result;

    }

    protected static function getSentencesFromJSON($json) {

        $sentencesArray = json_decode($json, true);
        $sentences = "";
        foreach ($sentencesArray["sentences"] as $s) {
            $sentences .= $s["trans"];
        }
        return $sentences;

    }

    /**
     * Translator
     *
     * @param $translate_type
     * @param $translate_data
     * @return mixed $translated
     */
    public static function converter( $translate_type, $translate_data ) {

        // Check if type is Month
        if ( $translate_type == 'month' ){

            $eng = array(
                "Jan",
                "Feb",
                "Mar",
                "Apr",
                "May",
                "Jun",
                "Jul",
                "Aug",
                "Sep",
                "Oct",
                "Nov",
                "Dec"
            );

            $per = array(
                "ژانویه",
                "فبریه",
                "مارس",
                "آوریل",
                "می",
                "ژوئن",
                "جولای",
                "آگوست",
                "سپتامبر",
                "اکتبر",
                "نوامبر",
                "دسامبر"
            );

            $translated = str_replace( $eng,$per,$translate_data );
        }

        // Check if Type is Genre 
        if ( $translate_type == 'genre' ){

            if( !is_array( $translate_data ) ) {

                $values = explode( ',' , $translate_data );

            }else {

                $values = implode( ',', $translate_data );

            }

            $eng = array(
                "Action",
                "Drama",
                "Mystery",
                "Thriller",
                "Musical",
                "Music",
                "Short",
                "Western",
                "History",
                "Biography",
                "Animation",
                "War",
                "Documentary",
                "Family",
                "Fantasy",
                "Sci-Fi",
                "Adventure",
                "Horror",
                "Crime",
                "Romance",
                "Comedy",
                "News",
                "Sports",
                "Film Noir",
                "Reality-TV",
                "Talk Show",
                "Game Show",
                "Childcare",
                "Shounen",
                "Isekai",
                "Mecha",
                "Reincarnation",
                "School",
                "Harem",
                "Military",
                "Josei",
                "Love Polygon",
                "Strategy Game",
                "Slice of Life",
                "Romantic Subtext",
                "Mythology",
                "Supernatural",
                "Suspense",
                "Psychological",
                "Time Travel",
                "Girls Love",
                "Boys Love",
                "Gourmet",
                "Ecchi",
                "Kids",
                "Shoujo",
                "Gag Humor",
                "Vampire",
                "Super Power",
                "Parody",
                "Gore",
                "Space",
                "Survival",
                "Team Sports",
                "Martial Arts",
                "Medical",
                "Anthropomorphic",
                "Organized Crime",
                "Adult Cast",
                "Samurai",
                "Visual Arts",
                "Video Game",
                "Mahou Shoujo",
                "Assassins",
                "Super power",
                "Video Games",
                "CGI",
                "CGDCT",
                "Showbiz",
                "Iyashikei",
                "Otaku Culture",
                "Workplace",
                "Seinen",
                "High Stakes Game",
                "Reverse Harem",
                "Combat Sports",
                "Hentai",
                'Historical',
                "Magical Sex Shift",
                "N/A"
            );

            $per = array(
                "اکشن",
                "درام",
                "معمایی",
                "هیجان‌انگیز",
                "موزیکال",
                "موسیقی",
                "کوتاه",
                "وسترن",
                "تاریخی",
                "زندگی نامه",
                "انیمیشن",
                "جنگی",
                "مستند",
                "خانوادگی",
                "فانتزی",
                "علمی تخیلی",
                "ماجراجویی",
                "ترسناک",
                "جنایی",
                "عاشقانه",
                "کمدی",
                "خبری",
                "ورزشی",
                "فیلم نوآر",
                "واقع‌نما",
                "گفتگو تلویزیونی",
                "مسابقه تلویزیونی",
                "مراقبت از کودکان",
                "شونن",
                "ایسکای",
                "مکا",
                "تناسخ",
                "مدرسه‌ای",
                "حارم",
                "نظامی",
                "جوسی",
                "مثلث عشقی",
                "بازی",
                "برشی از زندگی",
                "زیرشاخه عاشقانه",
                "",
                "ماوراطبیعی",
                "دلهره‌آور",
                "روان‌شناختی",
                "سفر در زمان",
                "یوری",
                "یائویی",
                "خوراک شناسی",
                "ایچی",
                "کودکانه",
                "شوجو",
                "شوخ طبعی",
                "خون‌آشام",
                "قدرت های فوق العاده",
                "تقلید",
                "خشونت زیاد",
                "فضایی",
                "بقاء",
                "ورزش تیمی",
                "هنرهای رزمی",
                "پزشکی",
                "انسان‌انگاری",
                "جرائم سازمان‌یافته",
                "شخصیت بالغ",
                "سامورایی",
                "هنرهای نمایشی",
                "بازی ویدئویی",
                "دختر جادویی",
                "آدم‌کشی",
                "ابرقدرت",
                "بازی‌های ویدیویی",
                "سی‌جی‌آی",
                "دختران بامزه",
                "صنعت نمایش و سرگرمی",
                "آرامش بخش",
                "فرهنگ اوتاکویی",
                "زندگی کاری",
                "سینن",
                "بازی با ریسک بالا",
                "حارم معکوس",
                "ورزش های رزمی",
                "",
                "تاریخی",
                "تغییر جنسیت جادویی",
                "",
            );

            $translated = str_replace( $eng, $per, $values );

            return $translated;
        }

    }

    /**
     * Sanitize words
     *
     * @param  string $str
     */
    public static function sanitize_str( $str ) {

        $unwanted_array = array( 
            'Š'=>'S', 
            'š'=>'s', 
            'Ž'=>'Z', 
            'ž'=>'z', 
            'À'=>'A', 
            'Á'=>'A', 
            'Â'=>'A', 
            'Ã'=>'A', 
            'Ä'=>'A', 
            'Å'=>'A', 
            'Æ'=>'A', 
            'Ç'=>'C', 
            'È'=>'E', 
            'É'=>'E',       
            'Ê'=>'E', 
            'Ë'=>'E', 
            'Ì'=>'I', 
            'Í'=>'I', 
            'Î'=>'I', 
            'Ï'=>'I', 
            'Ñ'=>'N', 
            'Ò'=>'O', 
            'Ó'=>'O', 
            'Ô'=>'O', 
            'Õ'=>'O', 
            'Ö'=>'O', 
            'Ø'=>'O', 
            'Ù'=>'U',       
            'Ú'=>'U', 
            'Û'=>'U', 
            'Ü'=>'U', 
            'Ý'=>'Y', 
            'Þ'=>'B', 
            'ß'=>'Ss', 
            'à'=>'a', 
            'á'=>'a', 
            'â'=>'a', 
            'ã'=>'a', 
            'ä'=>'a', 
            'å'=>'a', 
            'æ'=>'a', 
            'ç'=>'c',
            'è'=>'e', 
            'é'=>'e', 
            'ê'=>'e', 
            'ë'=>'e', 
            'ì'=>'i', 
            'í'=>'i', 
            'î'=>'i', 
            'ï'=>'i', 
            'ð'=>'o', 
            'ñ'=>'n', 
            'ò'=>'o', 
            'ó'=>'o', 
            'ô'=>'o', 
            'õ'=>'o',                    
            'ö'=>'o', 
            'ø'=>'o', 
            'ù'=>'u', 
            'ú'=>'u', 
            'û'=>'u', 
            'ý'=>'y', 
            'þ'=>'b', 
            'ÿ'=>'y' 
        );
    
        return strtr( $str, $unwanted_array );

    }

}